<?php
/**
 * Autoklasen Chat - Creare Operator
 * 
 * ATENȚIE: Șterge acest fișier după ce creezi operatorul!
 * 
 * Accesează: https://chat.autoklasen.ro/api/setup-operator.php
 */

require_once __DIR__ . '/config/database.php';

// Configurare operator - MODIFICĂ AICI
$operatorName = 'Vio';
$operatorEmail = 'vio@autoklasen.ro';
$operatorPassword = 'ParolaSecreta123!'; // Schimbă parola!

// Verifică dacă e accesat din browser
if (php_sapi_name() !== 'cli' && !isset($_GET['confirm'])) {
    ?>
    <!DOCTYPE html>
    <html lang="ro">
    <head>
        <meta charset="UTF-8">
        <title>Setup Operator - Autoklasen Chat</title>
        <style>
            body { font-family: sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
            .warning { background: #fff3cd; border: 1px solid #ffc107; padding: 15px; border-radius: 8px; margin: 20px 0; }
            .info { background: #e7f3ff; border: 1px solid #2196F3; padding: 15px; border-radius: 8px; margin: 20px 0; }
            code { background: #f5f5f5; padding: 2px 6px; border-radius: 4px; }
            button { background: #e94560; color: white; border: none; padding: 12px 24px; border-radius: 6px; cursor: pointer; font-size: 16px; }
            button:hover { background: #d63050; }
        </style>
    </head>
    <body>
        <h1>🔧 Setup Operator</h1>
        
        <div class="warning">
            <strong>⚠️ ATENȚIE:</strong> Șterge acest fișier după ce creezi operatorul!
        </div>
        
        <div class="info">
            <p><strong>Se va crea operatorul:</strong></p>
            <ul>
                <li>Nume: <code><?= htmlspecialchars($operatorName) ?></code></li>
                <li>Email: <code><?= htmlspecialchars($operatorEmail) ?></code></li>
                <li>Parolă: <code><?= htmlspecialchars($operatorPassword) ?></code></li>
            </ul>
            <p><em>Modifică datele direct în fișier dacă vrei alte valori.</em></p>
        </div>
        
        <form method="get">
            <input type="hidden" name="confirm" value="1">
            <button type="submit">✅ Creează Operator</button>
        </form>
    </body>
    </html>
    <?php
    exit;
}

// Creează operatorul
try {
    $pdo = getDBConnection();
    
    // Verifică dacă există deja
    $stmt = $pdo->prepare("SELECT id FROM operators WHERE email = ?");
    $stmt->execute([$operatorEmail]);
    
    if ($stmt->fetch()) {
        die("❌ Operatorul cu email-ul {$operatorEmail} există deja!");
    }
    
    // Hash parolă
    $passwordHash = password_hash($operatorPassword, PASSWORD_DEFAULT);
    
    // Inserează
    $stmt = $pdo->prepare("
        INSERT INTO operators (name, email, password_hash, is_online, created_at) 
        VALUES (?, ?, ?, FALSE, NOW())
    ");
    $stmt->execute([$operatorName, $operatorEmail, $passwordHash]);
    
    $operatorId = $pdo->lastInsertId();
    
    echo "<h1>✅ Operator creat cu succes!</h1>";
    echo "<p>ID: {$operatorId}</p>";
    echo "<p>Email: {$operatorEmail}</p>";
    echo "<p><strong style='color:red'>ȘTERGE ACEST FIȘIER ACUM!</strong></p>";
    echo "<p>Apoi accesează dashboard-ul operator pentru login.</p>";
    
} catch (Exception $e) {
    die("❌ Eroare: " . $e->getMessage());
}
