<?php
/**
 * Înregistrează o pagină vizualizată
 * POST /api/endpoints/visitor/pageview.php
 * 
 * Input: { session_id: int, page_url: string, page_title?: string, previous_page_time?: int }
 * Output: { success: bool, page_view_id: int }
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://autoklasen.ro');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

require_once __DIR__ . '/../../config/database.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = getDB();
    
    $sessionId = $input['session_id'] ?? null;
    $pageUrl = $input['page_url'] ?? null;
    $pageTitle = $input['page_title'] ?? null;
    $previousPageTime = $input['previous_page_time'] ?? null;
    
    if (!$sessionId || !$pageUrl) {
        http_response_code(400);
        die(json_encode(['error' => 'session_id and page_url required']));
    }
    
    $now = date('Y-m-d H:i:s');
    
    // Verifică dacă sesiunea există
    $stmt = $db->prepare("SELECT id FROM sessions WHERE id = ?");
    $stmt->execute([$sessionId]);
    if (!$stmt->fetch()) {
        http_response_code(404);
        die(json_encode(['error' => 'Session not found']));
    }
    
    // Actualizează timpul pe pagina anterioară (dacă există)
    if ($previousPageTime !== null) {
        $stmt = $db->prepare("
            UPDATE page_views 
            SET left_at = ?, time_on_page = ? 
            WHERE session_id = ? AND left_at IS NULL
            ORDER BY id DESC LIMIT 1
        ");
        $stmt->execute([$now, $previousPageTime, $sessionId]);
    }
    
    // Înregistrează noua pagină
    $stmt = $db->prepare("
        INSERT INTO page_views (session_id, page_url, page_title, entered_at) 
        VALUES (?, ?, ?, ?)
    ");
    $stmt->execute([$sessionId, $pageUrl, $pageTitle, $now]);
    $pageViewId = $db->lastInsertId();
    
    echo json_encode([
        'success' => true,
        'page_view_id' => $pageViewId
    ]);

} catch (Exception $e) {
    error_log("Pageview error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Server error']);
}