<?php
/**
 * Autoklasen Chat - Operator trimite mesaj
 * POST /api/endpoints/operator/message.php
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../../config/database.php';

session_start();

// Verifică autentificare
if (!isset($_SESSION['operator_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$conversationId = $input['conversation_id'] ?? null;
$content = trim($input['content'] ?? '');

if (!$conversationId || empty($content)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'conversation_id și content sunt obligatorii']);
    exit;
}

try {
    $pdo = getDBConnection();
    
    // Verifică conversația - trebuie să fie a acestui operator
    $stmt = $pdo->prepare("SELECT id, status, operator_id, visitor_id FROM conversations WHERE id = ?");
    $stmt->execute([$conversationId]);
    $conversation = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$conversation) {
        http_response_code(404);
        echo json_encode(['success' => false, 'error' => 'Conversation not found']);
        exit;
    }
    
    if ($conversation['operator_id'] != $_SESSION['operator_id']) {
        http_response_code(403);
        echo json_encode(['success' => false, 'error' => 'Nu aveți acces la această conversație']);
        exit;
    }
    
    if ($conversation['status'] === 'closed') {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Conversația este închisă']);
        exit;
    }
    
    // Salvează mesajul
    $stmt = $pdo->prepare("
        INSERT INTO messages (conversation_id, sender_type, sender_id, content, sent_at) 
        VALUES (?, 'operator', ?, ?, NOW())
    ");
    $stmt->execute([$conversationId, $_SESSION['operator_id'], $content]);
    $messageId = $pdo->lastInsertId();
    
    // Update last_active operator
    $stmt = $pdo->prepare("UPDATE operators SET last_active = NOW() WHERE id = ?");
    $stmt->execute([$_SESSION['operator_id']]);
    
    echo json_encode([
        'success' => true,
        'message_id' => $messageId,
        'sent_at' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Server error']);
}
