<?php
/**
 * Autoklasen Chat - Lista conversații pentru operator
 * GET /api/endpoints/operator/conversations.php
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../../config/database.php';

session_start();

// Verifică autentificare
if (!isset($_SESSION['operator_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit;
}

try {
    $pdo = getDBConnection();
    
    // Parametri opționali
    $status = $_GET['status'] ?? 'active'; // active, all, closed
    
    // Construiește query
    $where = "WHERE 1=1";
    $params = [];
    
    if ($status === 'active') {
        $where .= " AND c.status IN ('ai_active', 'operator_active')";
    } elseif ($status === 'closed') {
        $where .= " AND c.status = 'closed'";
    }
    
    $sql = "
        SELECT 
            c.id,
            c.visitor_id,
            c.status,
            c.started_at,
            c.page_started,
            c.operator_id,
            v.total_visits,
            v.city,
            s.landing_page,
            s.referrer,
            o.name as operator_name,
            (SELECT content FROM messages WHERE conversation_id = c.id ORDER BY sent_at DESC LIMIT 1) as last_message,
            (SELECT sender_type FROM messages WHERE conversation_id = c.id ORDER BY sent_at DESC LIMIT 1) as last_sender,
            (SELECT sent_at FROM messages WHERE conversation_id = c.id ORDER BY sent_at DESC LIMIT 1) as last_message_time,
            (SELECT COUNT(*) FROM messages WHERE conversation_id = c.id) as message_count,
            (SELECT COUNT(*) FROM messages WHERE conversation_id = c.id AND sender_type != 'visitor' AND read_at IS NULL) as unread_count
        FROM conversations c
        LEFT JOIN visitors v ON c.visitor_id = v.id
        LEFT JOIN sessions s ON c.session_id = s.id
        LEFT JOIN operators o ON c.operator_id = o.id
        $where
        ORDER BY 
            CASE WHEN c.status = 'ai_active' THEN 0 ELSE 1 END,
            last_message_time DESC
        LIMIT 50
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $conversations = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Formatează datele
    foreach ($conversations as &$conv) {
        $conv['is_new'] = $conv['status'] === 'ai_active';
        $conv['last_message_preview'] = mb_substr($conv['last_message'] ?? '', 0, 80);
        if (strlen($conv['last_message'] ?? '') > 80) {
            $conv['last_message_preview'] .= '...';
        }
    }
    
    echo json_encode([
        'success' => true,
        'conversations' => $conversations,
        'count' => count($conversations)
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Server error']);
}
