<?php
/**
 * Autoklasen Chat - Operator închide conversația
 * POST /api/endpoints/operator/close.php
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../../config/database.php';

session_start();

if (!isset($_SESSION['operator_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$conversationId = $input['conversation_id'] ?? null;
$summary = trim($input['summary'] ?? '');
$tags = trim($input['tags'] ?? '');

if (!$conversationId) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'conversation_id required']);
    exit;
}

try {
    $pdo = getDBConnection();
    
    // Verifică conversația
    $stmt = $pdo->prepare("SELECT id, operator_id, visitor_id FROM conversations WHERE id = ?");
    $stmt->execute([$conversationId]);
    $conversation = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$conversation) {
        http_response_code(404);
        echo json_encode(['success' => false, 'error' => 'Conversation not found']);
        exit;
    }
    
    // Doar operatorul care a preluat poate închide (sau admin)
    if ($conversation['operator_id'] && $conversation['operator_id'] != $_SESSION['operator_id']) {
        http_response_code(403);
        echo json_encode(['success' => false, 'error' => 'Nu aveți permisiune']);
        exit;
    }
    
    // Închide conversația
    $stmt = $pdo->prepare("
        UPDATE conversations 
        SET status = 'closed', 
            ended_at = NOW(),
            summary = ?,
            tags = ?
        WHERE id = ?
    ");
    $stmt->execute([$summary ?: null, $tags ?: null, $conversationId]);
    
    // Log event
    $stmt = $pdo->prepare("
        INSERT INTO events (visitor_id, event_type, event_data) 
        VALUES (?, 'conversation_closed', ?)
    ");
    $stmt->execute([
        $conversation['visitor_id'],
        json_encode([
            'conversation_id' => $conversationId,
            'closed_by' => $_SESSION['operator_id']
        ])
    ]);
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Server error']);
}
