<?php
/**
 * Pornește o conversație nouă
 * POST /api/endpoints/chat/start.php
 * 
 * Input: { visitor_id: string, session_id: int, page_url: string, trigger_type: 'auto'|'manual' }
 * Output: { success: bool, conversation_id: int }
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://autoklasen.ro');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

require_once __DIR__ . '/../../config/database.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = getDB();
    
    $visitorId = $input['visitor_id'] ?? null;
    $sessionId = $input['session_id'] ?? null;
    $pageUrl = $input['page_url'] ?? '/';
    $triggerType = $input['trigger_type'] ?? 'manual';
    
    if (!$visitorId || !$sessionId) {
        http_response_code(400);
        die(json_encode(['error' => 'visitor_id and session_id required']));
    }
    
    // Verifică dacă vizitatorul și sesiunea există
    $stmt = $db->prepare("SELECT id FROM visitors WHERE id = ?");
    $stmt->execute([$visitorId]);
    if (!$stmt->fetch()) {
        http_response_code(404);
        die(json_encode(['error' => 'Visitor not found']));
    }
    
    $stmt = $db->prepare("SELECT id FROM sessions WHERE id = ? AND visitor_id = ?");
    $stmt->execute([$sessionId, $visitorId]);
    if (!$stmt->fetch()) {
        http_response_code(404);
        die(json_encode(['error' => 'Session not found']));
    }
    
    // Verifică dacă există deja o conversație activă în această sesiune
    $stmt = $db->prepare("
        SELECT id FROM conversations 
        WHERE session_id = ? AND status != 'closed'
    ");
    $stmt->execute([$sessionId]);
    $existing = $stmt->fetch();
    
    if ($existing) {
        // Returnează conversația existentă
        echo json_encode([
            'success' => true,
            'conversation_id' => $existing['id'],
            'existing' => true
        ]);
        exit;
    }
    
    $now = date('Y-m-d H:i:s');
    
    // Creează conversație nouă
    $stmt = $db->prepare("
        INSERT INTO conversations (visitor_id, session_id, status, started_at, trigger_type, page_started) 
        VALUES (?, ?, 'ai_active', ?, ?, ?)
    ");
    $stmt->execute([$visitorId, $sessionId, $now, $triggerType, $pageUrl]);
    $conversationId = $db->lastInsertId();
    
    // Incrementează contorul de conversații al vizitatorului
    $stmt = $db->prepare("
        UPDATE visitors SET total_conversations = total_conversations + 1 WHERE id = ?
    ");
    $stmt->execute([$visitorId]);
    
    // Loghează evenimentul
    $stmt = $db->prepare("
        INSERT INTO events (visitor_id, session_id, event_type, event_data) 
        VALUES (?, ?, 'conversation_started', ?)
    ");
    $stmt->execute([$visitorId, $sessionId, json_encode([
        'conversation_id' => $conversationId,
        'trigger_type' => $triggerType,
        'page' => $pageUrl
    ])]);
    
    echo json_encode([
        'success' => true,
        'conversation_id' => $conversationId,
        'existing' => false
    ]);

} catch (Exception $e) {
    error_log("Chat start error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Server error']);
}