<?php
/**
 * Obține istoricul unei conversații
 * GET /api/endpoints/chat/history.php?conversation_id=X&visitor_id=Y
 * 
 * Output: { success: bool, messages: array, status: string }
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://autoklasen.ro');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

require_once __DIR__ . '/../../config/database.php';

try {
    $conversationId = $_GET['conversation_id'] ?? null;
    $visitorId = $_GET['visitor_id'] ?? null;
    
    if (!$conversationId || !$visitorId) {
        http_response_code(400);
        die(json_encode(['error' => 'conversation_id and visitor_id required']));
    }
    
    $db = getDB();
    
    // Verifică dacă conversația aparține vizitatorului
    $stmt = $db->prepare("
        SELECT id, status, started_at, operator_id 
        FROM conversations 
        WHERE id = ? AND visitor_id = ?
    ");
    $stmt->execute([$conversationId, $visitorId]);
    $conversation = $stmt->fetch();
    
    if (!$conversation) {
        http_response_code(404);
        die(json_encode(['error' => 'Conversation not found']));
    }
    
    // Obține toate mesajele
    $stmt = $db->prepare("
        SELECT id, sender_type, content, sent_at 
        FROM messages 
        WHERE conversation_id = ? 
        ORDER BY sent_at ASC
    ");
    $stmt->execute([$conversationId]);
    $messages = $stmt->fetchAll();
    
    // Obține numele operatorului dacă a preluat
    $operatorName = null;
    if ($conversation['operator_id']) {
        $stmt = $db->prepare("SELECT name FROM operators WHERE id = ?");
        $stmt->execute([$conversation['operator_id']]);
        $operator = $stmt->fetch();
        $operatorName = $operator['name'] ?? null;
    }
    
    echo json_encode([
        'success' => true,
        'conversation_id' => (int)$conversationId,
        'status' => $conversation['status'],
        'started_at' => $conversation['started_at'],
        'operator_name' => $operatorName,
        'messages' => $messages,
        'last_id' => count($messages) > 0 ? end($messages)['id'] : 0
    ]);

} catch (Exception $e) {
    error_log("History error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Server error']);
}