<?php
/**
 * Închide o conversație
 * POST /api/endpoints/chat/close.php
 * 
 * Input: { conversation_id: int, visitor_id: string }
 * Output: { success: bool }
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://autoklasen.ro');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

require_once __DIR__ . '/../../config/database.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = getDB();
    
    $conversationId = $input['conversation_id'] ?? null;
    $visitorId = $input['visitor_id'] ?? null;
    
    if (!$conversationId || !$visitorId) {
        http_response_code(400);
        die(json_encode(['error' => 'conversation_id and visitor_id required']));
    }
    
    // Verifică și închide conversația
    $stmt = $db->prepare("
        UPDATE conversations 
        SET status = 'closed', ended_at = NOW() 
        WHERE id = ? AND visitor_id = ? AND status != 'closed'
    ");
    $stmt->execute([$conversationId, $visitorId]);
    
    if ($stmt->rowCount() === 0) {
        http_response_code(404);
        die(json_encode(['error' => 'Conversation not found or already closed']));
    }
    
    // Loghează evenimentul
    $stmt = $db->prepare("
        INSERT INTO events (visitor_id, session_id, event_type, event_data) 
        SELECT visitor_id, session_id, 'conversation_closed', ?
        FROM conversations WHERE id = ?
    ");
    $stmt->execute([json_encode(['closed_by' => 'visitor']), $conversationId]);
    
    echo json_encode([
        'success' => true,
        'conversation_id' => (int)$conversationId
    ]);

} catch (Exception $e) {
    error_log("Close error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Server error']);
}