# Assets pentru PWA Operator

## Fișiere necesare

```
assets/
├── icon-192.png      (192x192 px) - Iconiță PWA
├── icon-512.png      (512x512 px) - Iconiță PWA mare
└── sounds/
    └── notification.mp3  - Sunet notificare (același ca în widget)
```

## Generare iconițe

### Opțiunea 1: Online Generator
1. Mergi la: https://favicon.io/favicon-generator/
2. Text: "AK" sau "💬"
3. Background: #e94560
4. Font Color: #ffffff
5. Descarcă și redenumește

### Opțiunea 2: Din logo existent
1. Mergi la: https://realfavicongenerator.net/
2. Încarcă logo Autoklasen
3. Descarcă pachetul
4. Extrage icon-192.png și icon-512.png

### Opțiunea 3: Canva
1. Creează design 512x512
2. Background: #e94560
3. Text: "AK" alb, bold
4. Exportă PNG
5. Redimensionează la 192x192 pentru cealaltă variantă

## Sunet notificare

Copiază același `notification.mp3` din `widget/assets/` în `operator/assets/sounds/`.

```bash
cp widget/assets/notification.mp3 operator/assets/sounds/
```

## Verificare PWA

După ce adaugi iconițele:
1. Deschide în Chrome: https://chat.autoklasen.ro/operator/
2. DevTools → Application → Manifest
3. Verifică că iconițele se încarcă
4. Chrome va afișa "Install app" în bara de adrese
